package jp.or.kazusa.sakurai.tool.exactmasscreate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;

/*
 * このソフトは、MFcalculatorで時間がかかっている計算の効率を上げるため、
 * 予め決められたルールに従って、あり得る構造式を先に計算しておくものである。
 *
 * 作成日： 2006/11/03
 */

/**
 * @author sakura
 */
public class CreateExactMassDbMain {

    public static int atomNum;          // 水素以外の元素の数
    static String[] atomLabel = null;   // 元素ラベル
    static int[] numLimit = null;       // 分子中に含まれる元素の最大数。

    private static int[] atomBond;
    private static double[] atomWeight;
    static double totalCalcNum;
    static double calcNum = 0;
    static NumberFormat form = NumberFormat.getInstance();

    /**
     * @param args
     */
    @SuppressWarnings("unused")
    public static void main(String[] args) {

        CreateExactMassDbMain m = new CreateExactMassDbMain();

    }

    public CreateExactMassDbMain() {

        File settingFile = new File("Setting.txt");

        boolean status = setAtomSettings(settingFile);

        if (status == false) {
            System.out.println("Aborted.");
            return;
        }

        totalCalcNum = 1;
        for (int i = 0; i < atomNum; i++) {
            totalCalcNum *= (numLimit[i] + 1);
        }

        form.setMinimumFractionDigits(1);
        form.setMaximumFractionDigits(1);

        File outFile = new File("out.txt");

        doCreate(outFile);

        System.out.println("\nFinished!");
    }

    private void doCreate(File outFile) {

        PrintWriter out = null;

        try {
            out = new PrintWriter(new FileWriter(outFile));

            for (int i = 0; i < atomNum; i++) {
                out.print("\t" + atomLabel[i]);
            }
            out.println("\tDBE\tFW");

            eGenerate(0, "", out);

        } catch (IOException ex) {
            ex.printStackTrace();

        } finally {
            out.close();
        }
    }

    private boolean setAtomSettings(File settingFile) {

        boolean ret = true;
        BufferedReader in = null;

        try {
            in = new BufferedReader(new FileReader(settingFile));
            String s;
            int count = 0;
            while ((s = in.readLine()) != null) {

                if (s.startsWith("#"))
                    continue;
                if (s.trim().equals(""))
                    continue;

                count++;
            }
            in.close();

            if (count == 0) {
                System.out.println("No element data.");
                return false;
            }

            atomNum = count;
            atomLabel = new String[atomNum];
            atomBond = new int[atomNum];
            atomWeight = new double[atomNum];
            numLimit = new int[atomNum];

            in = new BufferedReader(new FileReader(settingFile));

            count = 0;
            while ((s = in.readLine()) != null) {

                if (s.startsWith("#"))
                    continue;
                if (s.trim().equals(""))
                    continue;

                String[] line;
                line = s.split("\t");
                atomLabel[count] = line[0];
                atomBond[count] = Integer.parseInt(line[1]);
                atomWeight[count] = Double.parseDouble(line[2]);
                numLimit[count] = Integer.parseInt(line[3]);

                count++;
            }
            in.close();

        } catch (IOException ex) {
            ex.printStackTrace();
            ret = false;
        } finally {
            try {
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return ret;
    }

    private String eGenerate(int nowAtom, String org, PrintWriter out) {

        if (nowAtom > atomNum - 1) {
            calcNum++;
            if (calcNum % 1000000 == 0) {
                double rate = calcNum / totalCalcNum * 100;
                System.out.println("processed: " + calcNum + " / "
                        + totalCalcNum + " (" + form.format(rate) + " %)");
            }

            double[] dbe = new double[1];
            double[] fw = new double[1];

            int flag = estimation(org, dbe, fw);

            if (flag == 1) {
                out.println(org + "\t" + dbe[0] + "\t" + fw[0]);
            }

            return org;
        } else {

            for (int i = -1; i < numLimit[nowAtom]; i++) {

                eGenerate(nowAtom + 1, org + "\t" + Integer.toString(i + 1),
                        out);
            }

        }

        return "";
    }

    private int estimation(String org, double[] retdbe, double[] retfw) {

        int flag = 0;
        String[] line;

        int[] eNum = new int[atomNum];

        line = org.split("\t");

        for (int i = 1; i < line.length; i++)
            eNum[i - 1] = Integer.parseInt(line[i]);

        int totalBondNum = 0;
        int totalAtomNum = 0;

        retdbe[0] = 0;
        retfw[0] = 0;

        for (int i = 0; i < eNum.length; i++) {
            totalBondNum += eNum[i] * atomBond[i];
            totalAtomNum += eNum[i];

            retdbe[0] += (double) (eNum[i] * (atomBond[i] - 2)) / 2;
            retfw[0] += (double) eNum[i] * atomWeight[i];

        }
        retdbe[0] += 1;

        if (totalBondNum % 2 == 0 && totalBondNum >= 2 * (totalAtomNum - 1)) {
            flag = 1;
        }

        return flag;
    }

}
